import 'package:flutter/material.dart';
import 'package:go_router/go_router.dart';

class AppBarAlertDailog extends StatelessWidget {
  const AppBarAlertDailog({
    super.key,
    required this.title,
    this.onTapClose,
    this.closeIcon,
  });
  final String title;
  final VoidCallback? onTapClose;
  final IconData? closeIcon;
  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Expanded(child: Text(title, overflow: TextOverflow.ellipsis)),

        Tooltip(
          message: 'close alert',
          padding: const EdgeInsets.fromLTRB(8, 4, 8, 4),
          decoration: BoxDecoration(
            borderRadius: const BorderRadius.all(Radius.circular(8)),
            color: Colors.grey.shade600,
          ),
          mouseCursor: MouseCursor.uncontrolled,
          child: IconButton(
            onPressed: onTapClose ?? () => context.pop(),
            icon: Icon(closeIcon ?? Icons.close, size: 20),
          ),
        ),
      ],
    );
  }
}
