import 'package:flutter/material.dart';
import 'package:zabino/core/utils/responsive.dart';

class ResponsiveColumnOrRow extends StatelessWidget {
  const ResponsiveColumnOrRow({super.key, required this.widgetList});
  final List<Widget> widgetList;

  @override
  Widget build(BuildContext context) {
    return Responsive.isMobile(context)
        ? Column(
            spacing: 16,
            mainAxisSize: MainAxisSize.min,
            children: widgetList.map((item) => item).toList(),
          )
        : Row(
            spacing: 16,
            children: widgetList.map((item) => Expanded(child: item)).toList(),
          );
  }
}
